/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.nio.FloatBuffer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.GameRendererContext;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    private final ChunkShaderFogComponent fogShader;

    protected ChunkProgram(RenderDevice owner, ResourceLocation name, int handle, Function<ChunkProgram, ChunkShaderFogComponent> fogShaderFunction) {
        super(owner, name, handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.fogShader = fogShaderFunction.apply(this);
    }

    public void setup(float modelScale, float textureScale) {
        GL20.glUniform1i((int)this.uBlockTex, (int)0);
        GL20.glUniform1i((int)this.uLightTex, (int)1);
        GL20.glUniform3f((int)this.uModelScale, (float)modelScale, (float)modelScale, (float)modelScale);
        GL20.glUniform2f((int)this.uTextureScale, (float)textureScale, (float)textureScale);
        this.fogShader.setup();
        GL20.glUniformMatrix4((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)GameRendererContext.getModelViewProjectionMatrix());
    }
}

